% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_genotypes.R
\name{show_genotypes}
\alias{show_genotypes}
\alias{show_genotypes.tbl_df}
\alias{show_genotypes.vctrs_bigSNP}
\title{Show the genotypes of a \code{gen_tibble}}
\usage{
show_genotypes(.x, indiv_indices = NULL, loci_indices = NULL, ...)

\method{show_genotypes}{tbl_df}(.x, indiv_indices = NULL, loci_indices = NULL, ...)

\method{show_genotypes}{vctrs_bigSNP}(.x, indiv_indices = NULL, loci_indices = NULL, ...)
}
\arguments{
\item{.x}{a vector of class \code{vctrs_bigSNP} (usually the \code{genotype} column of
a \code{\link{gen_tibble}} object),
or a \code{\link{gen_tibble}}.}

\item{indiv_indices}{indices of individuals}

\item{loci_indices}{indices of loci}

\item{...}{currently unused.}
}
\value{
a matrix of counts of the alternative alleles (see \code{\link[=show_loci]{show_loci()}}) to
extract information on the alleles for those loci from a \code{\link{gen_tibble}}.
}
\description{
Extract the genotypes (as a matrix) from a  \code{gen_tibble}.
}
\examples{
example_gt <- load_example_gt("gen_tbl")

example_gt \%>\% show_genotypes()
}
