% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/schema.R
\name{schema}
\alias{schema}
\title{Generate a \code{schema} object.}
\usage{
schema(
  conf_data,
  start_data,
  col_schema = NULL,
  enforce = TRUE,
  coerce_to_factors = FALSE,
  coerce_to_doubles = FALSE,
  na_factor_to_level = TRUE,
  na_numeric_to_ind = TRUE
)
}
\arguments{
\item{conf_data}{A data frame to be synthesized.}

\item{start_data}{A data frame with starting variables.}

\item{col_schema}{An optional named list of columns in the confidential data
with their properties, including data type and factor levels. If NULL or only
partially specified, \code{col_schema} will be inferred from the confidential data.
See example code for formatting.}

\item{enforce}{Boolean that if true, will preprocess both \code{conf_data} and \code{start_data}
to align with \code{col_schema} and the arguments below.}

\item{coerce_to_factors}{Boolean that if true, coerces categorical data types
(\code{chr}, \code{fct}, \code{ord}) to base \code{R} factors when \code{enforce_schema} is called.}

\item{coerce_to_doubles}{Boolean that if true, coerces columns specified as \code{dbl}
in \code{col_schema} to base \code{R} doubles when \code{enforce_schema} is called.}

\item{na_factor_to_level}{Boolean that if true, applies \code{convert_level_to_na()}
to factor variables when \code{enforce_schema} is called.}

\item{na_numeric_to_ind}{Boolean that if true, applies \code{expand_na()} to numeric data
to create logical missingness indicators when \code{enforce_schema} is called.}
}
\value{
A \code{schema} object.
}
\description{
Generate a \code{schema} object.
}
\examples{

conf_data <- data.frame(
  var1 = c("1", "1", "2"),
  var2 = c(1L, 2L, 3L),
  var3 = c(1.1, 2.2, 3.3)
)

start_data <- dplyr::select(conf_data, var1)

# default inferred schema
schema(
  conf_data = conf_data,
  start_data = start_data
)

# overwriting factor levels
schema(
  conf_data = conf_data,
  start_data = start_data,
  col_schema = list(
    "var1" = list(
      "dtype" = "fct",
      "levels" = c("1", "2", "3")
    )
  ),
  coerce_to_factors = TRUE
)


}
