% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/number_frost_day.R
\name{number_frost_day}
\alias{number_frost_day}
\title{Calculate the number of frost days}
\usage{
number_frost_day(
  .data,
  threshold = get_weather_option("extreme.frost_threshold"),
  require_full_year = get_weather_option("require_full_year")
)
}
\arguments{
\item{.data}{A data frame or tibble containing daily minimum temperatures in a column named "mint".}

\item{threshold}{The stress temperature threshold for frost (default: 0)}

\item{require_full_year}{Logical. If TRUE, requires exactly 365 or 366 days (default: TRUE)}
}
\value{
An data.frame or tibble representing the number of frost days, or 0 if no frost occurs
}
\description{
This function calculates the number of frost days from a numeric vector of daily
minimum temperatures using tidyverse principles.
}
\examples{
file <- system.file("extdata/ppd_72150.met", package = "tidyweather")
records <- read_weather(file)
records |>
    dplyr::group_by(year) |> 
    number_frost_day(require_full_year = FALSE)
}
