% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iqa.R
\name{iqa}
\alias{iqa}
\title{Water Quality Index (WQI / IQA)}
\usage{
iqa(
  df,
  pesos = c(od = 0.17, coliformes = 0.15, dbo = 0.1, nt_total = 0.1, p_total = 0.1,
    turbidez = 0.08, tds = 0.08, pH = 0.12, temperatura = 0.1),
  method = c("CETESB_approx"),
  na_rm = FALSE,
  add_status = TRUE,
  locale = c("pt", "en"),
  ...
)
}
\arguments{
\item{df}{Data frame (ou tibble) com as colunas requeridas.
Nomes esperados (portugues): \code{od}, \code{coliformes},
\code{dbo}, \code{nt_total}, \code{p_total}, \code{turbidez},
\code{tds}, \code{ph} (ou \code{pH}), \code{temperatura}.}

\item{pesos}{Pesos nomeados para cada parametro. Padroes seguem pratica
CETESB/NSF: \code{od=.17}, \code{coliformes=.15}, \code{dbo=.10},
\code{nt_total=.10}, \code{p_total=.10}, \code{turbidez=.08},
\code{tds=.08}, \code{pH=.12}, \code{temperatura=.10}.}

\item{method}{Conjunto de curvas de interpolacao; atualmente apenas
\code{"CETESB_approx"}.}

\item{na_rm}{Logico; se \code{FALSE} (padrao), linhas com Qi ausentes
geram erro. Se \code{TRUE}, o IQA e computado usando apenas os
parametros disponiveis e o denominador e ajustado para a soma dos
pesos presentes.}

\item{add_status}{Logico; se \code{TRUE} (padrao), adiciona a coluna
\code{IQA_status} com a classificacao qualitativa (0-100).}

\item{locale}{Idioma de \code{IQA_status}: \code{"pt"} (padrao) ou
\code{"en"}.}

\item{...}{Reservado para uso futuro (ignorado).}
}
\value{
O \code{df} de entrada com a coluna numerica \code{IQA} (0-100) e,
quando \code{add_status = TRUE}, a coluna fator \code{IQA_status}.
O atributo \code{"iqa_method"} e definido no objeto retornado.
}
\description{
Computa o IQA/WQI combinando subindices (Qi) por \strong{media ponderada}.
Os subindices sao obtidos por interpolacao linear por trechos sobre
curvas aproximadas (estilo CETESB/NSF).
}
\details{
Compatibilidade de nomes:
\itemize{
\item A tabela de curvas usa a chave \code{"pH"}.
Se seus dados possuem \code{ph} (minusculo), a curva \code{"pH"}
e mapeada para a coluna \code{ph}.
\item Para \code{temperatura}, a coluna \code{temp} (alias comum)
e automaticamente aceita caso \code{temperatura} nao exista.
}

Se as curvas internas retornarem Qi em 0-10 (variante historica),
o valor agregado e normalizado internamente para 0-100 antes do retorno.
Valores finais sao limitados ao intervalo \code{[0, 100]}.
}
\examples{
d <- wq_demo
d2 <- iqa(d, na_rm = TRUE)
table(d2$IQA_status, useNA = "ifany")

}
