% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loop_timechecker.R
\name{set_loop_timechecker}
\alias{set_loop_timechecker}
\title{Print elapsed and remaining time in iterative processes.}
\usage{
set_loop_timechecker(
  n_iter,
  overwrite = TRUE,
  timestep = 0.5,
  show_timestamp = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{n_iter}{The number of iterations.}

\item{overwrite}{Logical. Should the message be overwritten?}

\item{timestep}{The smallest time step of the output (sec).}

\item{show_timestamp}{Logical. Should the time stamp be added to the message?}

\item{verbose}{Logical. Should the progress be printed in the console?}
}
\value{
A function \code{loop_timechecker}.
  When placed at the end of the iterations,
  it records and prints the progress of iteration, elapsed time,
  and predicted remaining time.
  You can add arbitrary strings to the printed messages
  by using \code{char_pre} and \code{char_post} arguments.
}
\description{
\code{set_loop_timechecker} returns a function that records and prints
processing time in iterative processes.
}
\details{
Provided with the number of iterations,
this function creates a function named \code{loop_timechecker}
which records and prints processing time in iterative process.
In actual usage, it is recommended to call this function and
creating \code{loop_timechecker} right before the iteration process,
and place the \code{loop_timechecker}
at the end of the iteration process.

If you want to keep all printed records in your console,
please set \code{overwrite = FALSE}.

The \code{timestep} argument determines the frequency of updating
printed information since too fast updates will decrease visibility.
}
\examples{
\donttest{
iters <- 1:1000
ans <- NULL
tc <- set_loop_timechecker(length(iters))
for (i in iters) {
  ans <- c(ans, i)
  Sys.sleep(0.002)
  tc()
}

# For multiple loops, overwrite and char_pre arguments can be used for readability
iters1 <- 1:3
iters2 <- 1:100
ans <- NULL
tc1 <- set_loop_timechecker(length(iters1), overwrite = FALSE)
for (i in iters1) {
  tc2 <- set_loop_timechecker(length(iters2))
  for (j in iters2) {
    ans <- c(ans, i * j)
    Sys.sleep(0.004)
    tc2(char_pre = '-- ')
  }
  tc1()
}

# char_pre or char_post can also be used to check name of current process
iters <- paste0('case', LETTERS[1:10])
tc <- set_loop_timechecker(length(iters))
for (i in iters) {
  Sys.sleep(1)
  tc(char_post = paste0('  Processing ', i))
}
}
}
\seealso{
\code{\link{set_step_timechecker}}
}
