% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_research.r, R/shorthands.r
\name{tt_comments_api}
\alias{tt_comments_api}
\alias{tt_comments}
\title{Retrieve video comments}
\usage{
tt_comments_api(
  video_id,
  fields = "all",
  start_cursor = 0L,
  max_pages = 1L,
  cache = TRUE,
  verbose = interactive(),
  token = NULL
)

tt_comments(
  video_id,
  fields = "all",
  start_cursor = 0L,
  max_pages = 1L,
  cache = TRUE,
  verbose = interactive(),
  token = NULL
)
}
\arguments{
\item{video_id}{The id or URL of a video}

\item{fields}{The fields to be returned (defaults to all)}

\item{start_cursor}{The starting cursor, i.e., how many results to skip (for
picking up an old search).}

\item{max_pages}{results are returned in batches/pages with 100 videos. How
many should be requested before the function stops?}

\item{cache}{should progress be saved in the current session? It can then be
retrieved with \code{last_query()} if an error occurs. But the function
will use extra memory.}

\item{verbose}{should the function print status updates to the screen?}

\item{token}{The authentication token (usually supplied automatically after
running \link{auth_research} once).}
}
\value{
A data.frame of parsed comments.
}
\description{
\ifelse{html}{\figure{api-research.svg}{options: alt='[Works on: Research API]'}}{\strong{[Works on: Research API]}}
}
\examples{
\dontrun{
tt_comments("https://www.tiktok.com/@tiktok/video/7106594312292453675")
# OR
tt_comments("7106594312292453675")
# OR
tt_comments_api("7106594312292453675")
}
}
