% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate_data_pull.R
\name{validate_data_pull}
\alias{validate_data_pull}
\title{Validate Data Extraction}
\usage{
validate_data_pull(
  input,
  type = c("error", "warning", "message"),
  col,
  var_name = NULL,
  calls = NULL
)
}
\arguments{
\item{input}{A data frame or tibble.}

\item{type}{A character string specifying the type of message to be displayed
if the input is not numeric or if the values are out of range. Must be one
of "error", "warning", or "message".}

\item{col}{The column to be extracted.}

\item{var_name}{Optional. The name of the variable for error messaging.}

\item{calls}{Optional. The number of callers to go back in the call stack for
error messaging. If NULL, will default to 2.}
}
\value{
The extracted column as a vector.
}
\description{
This function extracts a column from a data frame or tibble and returns it as
a vector. If the column does not exist or an error occurs, it returns a clean
error message using the cli package.
}
\details{
This function is designed to validate and extract a specified column from a
data frame or tibble. When using \code{validate_data_pull()} within custom
functions, it is necessary to call a given bare column name  using tidy
evaluation (e.g., \code{{{ col }}}). This allows the function to correctly capture
and evaluate the column name within the custom function. However, when
calling this function directly on a data frame, tidy evaluation is not
required.
}
\author{
Nicolas Foss, Ed.D., MS
}
