% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsibble-package.R
\docType{package}
\name{tsibble-package}
\alias{tsibble-package}
\title{tsibble: tidy temporal data frames and tools}
\description{
\if{html}{\figure{logo.png}{options: style='text-align: right;'}}
The \strong{tsibble} package provides a data class of \code{tbl_ts} to represent tidy
temporal data. A tsibble consists of a time index, key, and other measured
variables in a data-centric format, which is built on top of the tibble.
}
\section{Index}{

An extensive range of indices are supported by tsibble:
\itemize{
\item native time classes in R (such as \code{Date}, \code{POSIXct}, and \code{difftime})
\item tsibble's new additions (such as \link{yearweek}, \link{yearmonth}, and \link{yearquarter}).
\item other commonly-used classes: \code{ordered}, \code{hms::hms}, \code{lubridate::period},
and \code{nanotime::nanotime}.
}

For a \code{tbl_ts} of regular interval, a choice of index representation has to
be made. For example, a monthly data should correspond to time index created
by \link{yearmonth}, instead of \code{Date} or \code{POSIXct}. Because months in a year
ensures the regularity, 12 months every year. However, if using \code{Date}, a
month containing days ranges from 28 to 31 days, which results in irregular
time space. This is also applicable to year-week and year-quarter.

Tsibble supports arbitrary index classes, as long as they can be ordered from
past to future. To support a custom class, you need to define \code{\link[=index_valid]{index_valid()}}
for the class and calculate the interval through \code{\link[=interval_pull]{interval_pull()}}.
}

\section{Key}{

Key variable(s) together with the index uniquely identifies each record:
\itemize{
\item Empty: an implicit variable. \code{NULL} resulting in a univariate time series.
\item A single variable: For example, \code{data(pedestrian)} uses \code{Sensor} as the key.
\item Multiple variables: For example, Declare \code{key = c(Region, State, Purpose)}
for \code{data(tourism)}.
Key can be created in conjunction with tidy selectors like \code{starts_with()}.
}
}

\section{Interval}{

The \link{interval} function returns the interval associated with the tsibble.
\itemize{
\item Regular: the value and its time unit including "nanosecond", "microsecond",
"millisecond", "second", "minute", "hour", "day", "week", "month", "quarter",
"year". An unrecognisable time interval is labelled as "unit".
\item Irregular: \code{as_tsibble(regular = FALSE)} gives the irregular tsibble. It is
marked with \code{!}.
\item Unknown: Not determined (\verb{?}), if it's an empty tsibble, or one entry for
each key variable.
}

An interval is obtained based on the corresponding index representation:
\itemize{
\item integerish numerics between 1582 and 2499: "year" (\code{Y}). Note the year of
1582 saw the beginning of the Gregorian Calendar switch.
\item \code{yearquarter}: "quarter" (\code{Q})
\item \code{yearmonth}: "month" (\code{M})
\item \code{yearweek}: "week" (\code{W})
\item \code{Date}: "day" (\code{D})
\item \code{difftime}: "week" (\code{W}), "day" (D), "hour" (\code{h}), "minute" (\code{m}), "second" (\code{s})
\item \code{POSIXt}/\code{hms}: "hour" (\code{h}), "minute" (\code{m}), "second" (\code{s}), "millisecond" (\code{us}),
"microsecond" (\code{ms})
\item \code{period}: "year" (\code{Y}), "month" (\code{M}), "day" (\code{D}), "hour" (\code{h}),
"minute" (\code{m}), "second" (\code{s}), "millisecond" (\code{us}), "microsecond" (\code{ms})
\item \code{nanotime}: "nanosecond" (\code{ns})
\item other numerics &\code{ordered} (ordered factor): "unit"
When the interval cannot be obtained due to the mismatched index format, an
error is issued.
}

The interval is invariant to subsetting, such as \code{filter()}, \code{slice()}, and \verb{[.tbl_ts}.
However, if the result is an empty tsibble, the interval is always unknown.
When joining a tsibble with other data sources and aggregating to different
time scales, the interval gets re-calculated.
}

\section{Time zone}{

Time zone corresponding to index will be displayed if index is \code{POSIXct}.
\verb{?} means that the obtained time zone is a zero-length character "".
}

\section{Print options}{

The tsibble package fully utilises the \code{print} method from the tibble. Please
refer to \link[tibble:tibble-package]{tibble::tibble-package} to change display options.
}

\examples{
# create a tsibble w/o a key ----
tsibble(
  date = as.Date("2017-01-01") + 0:9,
  value = rnorm(10)
)

# create a tsibble with one key ----
tsibble(
  qtr = rep(yearquarter("2010-01") + 0:9, 3),
  group = rep(c("x", "y", "z"), each = 10),
  value = rnorm(30),
  key = group
)
}
\seealso{
Useful links:
\itemize{
  \item \url{https://tsibble.tidyverts.org}
  \item \url{https://github.com/tidyverts/tsibble}
  \item Report bugs at \url{https://github.com/tidyverts/tsibble/issues}
}

}
\author{
\strong{Maintainer}: Mitchell O'Hara-Wild \email{mail@mitchelloharawild.com} (\href{https://orcid.org/0000-0001-6729-7695}{ORCID})

Authors:
\itemize{
  \item Earo Wang (\href{https://orcid.org/0000-0001-6448-5260}{ORCID})
  \item Di Cook (\href{https://orcid.org/0000-0002-3813-7155}{ORCID}) [thesis advisor]
  \item Rob Hyndman (\href{https://orcid.org/0000-0002-2140-5352}{ORCID}) [thesis advisor]
}

Other contributors:
\itemize{
  \item Tyler Smith [contributor]
  \item Wil Davis \email{william.davis@worthingtonindustries.com} [contributor]
}

}
