% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tspredbench.R
\docType{data}
\name{SantaFe.D}
\alias{SantaFe.D}
\title{Santa Fe Time Series Competition - Series D}
\format{
A data frame with one column and 100,500 rows, containing numeric time series values.
}
\source{
Santa Fe Time Series Competition dataset (original archive URL unavailable).
}
\usage{
data(SantaFe.D)
}
\description{
Univariate time series D from the Santa Fe Time Series Competition.
Data Type: Simulated nonlinear time series. Category: Benchmark. Observations: 100,500.
This benchmark dataset is composed of a four-dimensional nonlinear and non-stationary series.
Competitors were asked to predict the last 500 observations, and performance was evaluated using NMSE.
}
\examples{
# Load Santa Fe D series and plot a subset
data(SantaFe.D)
# SantaFe.D <- loadfulldata(SantaFe.D)
series <- SantaFe.D$V1
ts.plot(series[1:2000], ylab = "Value", xlab = "Index", main = "Santa Fe D (first 2000)")
}
\references{
Weigend, A.S. (1993). \emph{Time Series Prediction: Forecasting the Future and Understanding the Past}. Reading, MA: Westview Press.
}
\keyword{benchmark}
\keyword{datasets}
