% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tspredbench.R
\docType{data}
\name{m1}
\alias{m1}
\title{M1 Competition Time Series}
\format{
A list of dataframes containing time series.
}
\source{
\href{https://onlinelibrary.wiley.com/doi/10.1002/for.3980010202}{The accuracy of extrapolation (time series) methods: Results of a forecasting competition}
}
\usage{
data(m1)
}
\description{
Time series data from the first Makridakis forecasting competition (M1), held in 1982.
Data Type: Forecasting benchmark dataset. Category: Forecasting. Creation Date: 1982.
}
\details{
Consolidated list with frequencies as keys (e.g., \code{monthly}, \code{quarterly}, \code{yearly}). Each element is a list of series.
See Makridakis et al. (1982) for competition design and evaluation.
}
\examples{
# Load consolidated M1 list
data(m1)
# m1 <- loadfulldata(m1)

# List available frequency keys
names(m1)

# Plot one series from a frequency bucket
series <- m1$monthly[[1]]
ts.plot(series, main = "M1 monthly series")
}
\references{
Makridakis et al. (1982). The accuracy of extrapolation (time series) methods: Results of a forecasting competition. Journal of Forecasting, 1(2), 111–153.
}
\keyword{datasets}
