% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bal.stat.R
\name{bal.stat}
\alias{bal.stat}
\title{Calculate weighted balance statistics}
\usage{
bal.stat(
  data,
  vars = NULL,
  treat.var,
  w.all,
  sampw,
  get.means = TRUE,
  get.ks = TRUE,
  na.action = "level",
  estimand,
  multinom,
  fillNAs = FALSE
)
}
\arguments{
\item{data}{A data frame containing the data}

\item{vars}{A vector of character strings with the names of the variables 
on which the function will assess the balance}

\item{treat.var}{The name of the treatment variable}

\item{w.all}{Oobservation weights (e.g. propensity score weights, sampling 
weights, or both)}

\item{sampw}{Sampling weights. These are passed in addition to `w.all` because
the "unweighted" results shoud be adjusted for sample weights (though not propensity
score weights).}

\item{get.means}{logical. If `TRUE` then `bal.stat` will compute means
and variances}

\item{get.ks}{logical. If `TRUE` then `bal.stat` will compute KS statistics}

\item{na.action}{A character string indicating how `bal.stat` should 
handle missing values. Current options are "level", "exclude", or "lowest"}

\item{estimand}{Either "ATT" or "ATE"}

\item{multinom}{logical. `TRUE` if used for multinomial propensity scores.}

\item{fillNAs}{logical. If `TRUE`, fills in zeros for missing values.}
}
\value{
`get.means` and `get.ks` manipulate the inclusion of certain 
  columns in the returned result.
}
\description{
`bal.stat` compares the treatment and control subjects by means, standard 
deviations, effect size, and KS statistics
}
\details{
`bal.stat` calls  auxiliary functions for each variable and assembles
the results in a table.
}
\references{
Dan McCaffrey, G. Ridgeway, Andrew Morral (2004). "Propensity
  Score Estimation with Boosted Regression for Evaluating Adolescent
  Substance Abuse Treatment", *Psychological Methods* 9(4):403-425.
}
\seealso{
The example for [ps] contains an example of the use of [bal.table]
}
\keyword{multivariate}
