% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tweedie_dpqr.R
\name{Tweedie}
\alias{Tweedie}
\alias{dtweedie}
\alias{ptweedie}
\alias{qtweedie}
\alias{rtweedie}
\title{Tweedie distributions}
\usage{
dtweedie(y, xi = NULL, mu, phi, power = NULL, verbose = FALSE)

ptweedie(q, xi = NULL, mu, phi, power = NULL, verbose = FALSE)

qtweedie(p, xi = NULL, mu, phi, power = NULL)

rtweedie(n, xi = NULL, mu, phi, power = NULL)

ptweedie(q, xi = NULL, mu, phi, power = NULL, verbose = FALSE)

qtweedie(p, xi = NULL, mu, phi, power = NULL)

rtweedie(n, xi = NULL, mu, phi, power = NULL)
}
\arguments{
\item{y}{vector of quantiles.}

\item{xi}{scalar; the value of \eqn{\xi}{xi} such that the variance is \eqn{\mbox{var}[Y]=\phi\mu^{\xi}}{var[Y] = phi * mu^xi}. A synonym for \code{power}.}

\item{mu}{vector of mean \eqn{\mu}{mu}.}

\item{phi}{vector of dispersion parameters \eqn{\phi}{phi}.}

\item{power}{scalar; a synonym for \eqn{\xi}{xi}, the Tweedie index parameter.}

\item{verbose}{logical; if \code{TRUE}, some details of the algorithms used is shown. The default is \code{FALSE}.}

\item{q}{vector of quantiles.}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}
}
\value{
\code{dtweedie} gives the density, \code{ptweedie} gives the distribution function, \code{qtweedie} gives the quantile function, 
and \code{rtweedie} generates random deviates.

The length of the result is determined by \code{n} for \code{rtweedie}, and by the length of \code{mu} for other functions.
}
\description{
Density, distribution function, quantile function and random generation for the the Tweedie family of distributions, with mean \code{mu}, dispersion parameter \code{phi} and variance power \code{power} (or \code{xi}, a synonym for \code{power}).
}
\details{
The Tweedie \acronym{edm}s belong to the class of exponential dispersion models (\acronym{edm}s), known for their role in generalized linear models (\acronym{glm}s). 
The Tweedie distributions are the \acronym{edm}s with a variance of the form \eqn{\mbox{var}[Y] = \phi\mu^p}{var[Y] = phi*mu^p} where \eqn{p \ge 1}{p >= 1}.
\emph{This function only evaluates for \eqn{p \ge 1}{p >= 1}.}

Special cases are the Poisson (\eqn{p = 1} with \eqn{\phi = 1}{phi = 1}), gamma (\eqn{p = 2}), and inverse Gaussian (\eqn{p = 3}) distributions.
Evaluation is difficult for \eqn{p}{p} outside of \eqn{p = 0, 1, 2, 3}{power = 0, 1, 2, 3}. 
This function uses one of two primary methods, depending on the combination of parameters:
\enumerate{
  \item Evaluation of an infinite series (\code{dtweedie_series}).
  \item Interpolation from stored values computed via a Fourier inversion technique (\code{dtweedie_inversion}).
}
This function employs a two-dimensional interpolation procedure to compute
the density for some parts of the parameter space from previously computed
values (interpolation) and uses the series solution for others.

When \eqn{1<p<2}{1 < power < 2}, the density function include a positive probably for \eqn{Y = 0}.
}
\section{Note}{

\code{dtweedie} and \code{ptweedie} are the only functions generally to be called by users. 
Consequently, all checks on the function inputs are performed in these functions.
}

\examples{
# Compute a Tweedie density
power <- 1.1
mu <- 1
phi <- 1
y <- seq(0, 5, by = 0.5)
dtweedie(y, power = power, mu = mu, phi = phi)

# Compare to the saddlepoint density
dtweedie_saddle(y = y, power = power, mu = mu, phi = phi)

# The DF:
ptweedie(y, power = power, mu = mu, phi = phi)

}
\references{
Dunn, P. K. and Smyth, G. K. (2008).
Evaluation of Tweedie exponential dispersion model densities by Fourier inversion.
\emph{Statistics and Computing}, 
\bold{18}, 73--86.
\doi{10.1007/s11222-007-9039-6}

Dunn, Peter K and Smyth, Gordon K (2005).
Series evaluation of Tweedie exponential dispersion model densities
\emph{Statistics and Computing},
\bold{15}(4). 267--280.
\doi{10.1007/s11222-005-4070-y}

Jorgensen, B. (1997).
\emph{Theory of Dispersion Models}.
Chapman and Hall, London.
}
\seealso{
\code{\link{dtweedie_series}}, \code{\link{dtweedie_inversion}}, \code{\link{ptweedie_series}}, \code{\link{ptweedie_inversion}}, \code{\link{dtweedie_saddle}}, \code{\link{tweedie_lambda}}
}
\keyword{distribution}
