% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/early_global_combined.R
\docType{data}
\name{early_global_combined}
\alias{early_global_combined}
\title{John Hopkins data from the early outbreak}
\format{
An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 104036 rows and 9 columns.
}
\source{
\url{https://github.com/CSSEGISandData/COVID-19}
}
\usage{
data("early_global_combined")
}
\description{
Mined out the commit history of COVID-19 Data Repository by the Center for
Systems Science and Engineering (CSSE) at Johns Hopkins University this
dataset has early outbreak trajectories (21st Jan 2020 up to March 8th 2020)
for a wide range of geographies, for confirmed cases, deaths and recovered
cases. These trajectories are based on reported date, but are occasionally
revised which will vary from region to region and maybe between different
statistics, which show up as infrequent changes in published estimates over
time.
}
\details{
This data set is originally licensed under the Creative Commons Attribution
4.0 International (CC BY 4.0) by the Johns Hopkins University on behalf of
its Center for Systems Science in Engineering. Copyright Johns Hopkins
University 2020.

\describe{
\item{ \code{country} (chr) }{
The country
}
\item{ \code{province} (chr) }{
Sub-national division
}
\item{ \code{lat} (dbl) }{
Latitude
}
\item{ \code{long} (dbl) }{
Longitude
}
\item{ \code{reported_date} (date) }{
Date of the observation based on reports of cases on this date.
}
\item{ \code{total_cases} (dbl) }{
Cumulative cases
}
\item{ \code{published_date} (date) }{
Date the observation was published on the JHU github.
}
\item{ \code{total_deaths} (dbl) }{
Cumulative deaths
}
\item{ \code{total_recovered} (dbl) }{
Cumulative recovered
}
}
}
\examples{
dplyr::glimpse(early_global_combined)
}
\concept{datasets}
\keyword{datasets}
