% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/title_footer_decorator.R
\name{title_footer_decorator}
\alias{title_footer_decorator}
\title{Title and Footer Decorator}
\usage{
title_footer_decorator(
  output_name,
  titles_file,
  choices = NULL,
  selected = NULL
)
}
\arguments{
\item{output_name}{(\code{character(1)}) a name for the output object (e.g., a plot or table).}

\item{titles_file}{(\code{character(1)}) the path to an Excel file containing title and footer
information. The function expects the titles to be in the first sheet
named \code{Sheet1}.}

\item{choices}{(\code{character}) an array of titles and footers, which are available for
selection. Default \code{NULL}, indicates all titles and footers are available.}

\item{selected}{(\code{character(1)}) the selected title or footer. Default \code{NULL},
indicates no title or footer is selected.}
}
\value{
\code{\link[teal:teal_transform_module]{teal::teal_transform_module()}}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
A function to create a UI component for selecting a title and footer
for tables or plots. It reads title information from a specified Excel
file and allows users to choose a title from the provided options.
It also provides user with flexibility to customize the title and footer
according to their specific needs.
}
\details{
The module creates a UI with a dropdown for selecting a title.
Once a title is selected, it updates the output by either adding titles to
a table or modifying a plot's title and caption accordingly.
Additionally, it includes a checkbox that user can check to enable
customization, allowing them to enter their own values for the title and
footer in the designated input fields.
}
\examples{
library(openxlsx)
library(teal.modules.general)

example_excel <- data.frame(
  `TABLE ID` = c(
    "DO_NOT_DELETE",
    "TSFAE01A", "TSFAE01A", "TSFAE01A",
    "TSFAE01B", "TSFAE01B"
  ),
  IDENTIFIER = c(
    "DO_NOT_DELETE",
    "TITLE", "FOOTNOTE1", "FOOTNOTE2",
    "TITLE", "FOOTNOTE1"
  ),
  TEXT = c(
    "DO_NOT_DELETE",
    "Adverse Events Summary A", "Source: Clinical Study Report", "Confidential",
    "Adverse Events Summary B", "Draft Version"
  ),
  stringsAsFactors = FALSE,
  check.names = FALSE
)

temp_titles <- tempfile(fileext = ".xlsx")
write.xlsx(example_excel, temp_titles, sheetName = "Sheet1", asTable = TRUE)
plot_module <- tm_g_scatterplot(
  label = "Scatter Plot",
  x = data_extract_spec(
    dataname = "IRIS",
    select = select_spec(
      choices = variable_choices(
        "IRIS", c("Sepal.Length", "Sepal.Width")
      ), selected = "Sepal.Length"
    )
  ),
  y = data_extract_spec(
    dataname = "IRIS",
    select = select_spec(
      choices = variable_choices(
        "IRIS", c("Petal.Length", "Petal.Width")
      ), selected = "Petal.Length"
    )
  ),
  decorators = list(
    plot = title_footer_decorator(
      "plot", temp_titles,
      choices = c("TSFAE01A", "TSFAE01B"), selected = NULL
    )
  )
)

# Initialize the teal app
app <- init(
  data = teal_data(IRIS = iris),
  modules = list(plot_module)
)

# Run the app
if (interactive()) {
  shinyApp(app$ui, app$server)
}

}
\seealso{
For the exact Excel workbook layout expected by this function, see the package vignette:
\code{vignette("title-footer-decorator-excel-structure", package = "uteals")}
}
