# Test export function produces a file with expected content

# Helper functions ----
# Get the default download folder
.vald_default_export_dir <- function() {
  home <- Sys.getenv("USERPROFILE", unset = NA)
  if (is.na(home) || !nzchar(home)) {
    home <- Sys.getenv("HOME", unset = "~")
  }
  
  downloads <- file.path(home, "Downloads")
  
  # Fallback if Downloads doesn't exist
  if (!dir.exists(downloads)) {
    downloads <- tempdir()
  }
  
  file.path(downloads, "VALD_Exports")
}


# Delete the folder if it exists
delete_folder <- function(dir) {
  if (dir.exists(dir)) {
    unlink(dir, recursive = TRUE)
  }
}

# Set up default and custom directories, deleting them if they already exist
default_dir <- .vald_default_export_dir()
custom_dir <- paste(getwd(), "valdrtest", sep='\\')
delete_folder(default_dir)
delete_folder(custom_dir)

  
test_that("STEP 1: Export function produces a file in the default location", {
  # Make the export
  export_forcedecks_csv()
  
  # Check the number of files in default_dir is >1
  expect_gt(length(list.files(default_dir)), 0)
  
  
})

test_that("STEP 2: Exported file is in the expected format", {
  # Assuming first file in folder
  file <- read.csv(paste(default_dir, list.files(default_dir)[1], sep='\\'))
  
  # Test that there are non-zero rows and 10 column
  expect_gt(dim(file)[1], 0)
  expect_equal(dim(file)[2], 10)
})

test_that("STEP 3: Export function produces a file in the specified location", {
  # Export to a custom destination
  export_forcedecks_csv(custom_dir)
  
  # Expect that the custom directory has a file
  expect_equal(length(list.files(custom_dir)), 1)
  
})