% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayesian_glm.R
\name{fit_bayesian_glm_sectors}
\alias{fit_bayesian_glm_sectors}
\title{Fit Bayesian GLM for Each Sector}
\usage{
fit_bayesian_glm_sectors(
  direct_prices,
  production_prices,
  chains = 4L,
  iter = 4000L,
  seed = 12345L,
  verbose = TRUE
)
}
\arguments{
\item{direct_prices}{Data frame with direct prices. First column must be
'Year', remaining columns are sector values.}

\item{production_prices}{Data frame with prices of production. Must have
same structure as direct_prices.}

\item{chains}{Number of MCMC chains. Default 4.}

\item{iter}{Number of iterations per chain. Default 4000.}

\item{seed}{Random seed for reproducibility. Default 12345.}

\item{verbose}{Logical. Print progress messages. Default TRUE.}
}
\value{
A list with two elements:
\describe{
  \item{results}{List of results for each sector}
  \item{summary_table}{Data frame with summary statistics for all sectors}
}
}
\description{
Fits separate Bayesian generalized linear models for each sector,
regressing production prices on direct prices.
}
\details{
This function requires the 'rstanarm' and 'loo' packages to be installed.
Each sector model uses a Gaussian family with identity link and
weakly informative priors.
}
\examples{
\donttest{
if (requireNamespace("rstanarm", quietly = TRUE)) {
  set.seed(123)
  years <- 2000:2010

  direct <- data.frame(
    Year = years,
    Agriculture = 100 + cumsum(rnorm(11, 2, 1)),
    Manufacturing = 120 + cumsum(rnorm(11, 2, 1))
  )

  production <- data.frame(
    Year = years,
    Agriculture = 102 + cumsum(rnorm(11, 2, 1)),
    Manufacturing = 118 + cumsum(rnorm(11, 2, 1))
  )

  results <- fit_bayesian_glm_sectors(
    direct, production,
    chains = 2, iter = 1000
  )
  print(results$summary_table)
}
}

}
