% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glmlist.R
\name{glmlist}
\alias{glmlist}
\alias{loglmlist}
\alias{coef.glmlist}
\alias{get_models}
\title{Create a Model List Object}
\usage{
glmlist(...)

loglmlist(...)

\method{coef}{glmlist}(object, result = c("list", "matrix", "data.frame"), ...)

get_models(x, type = c("brackets", "formula"), abbrev = FALSE, ...)
}
\arguments{
\item{\dots}{Additional arguments passed to \code{loglin2string} (for \code{loglmlist})
such as \code{sep} and \code{collapse}.}

\item{object}{a \code{"glmlist"} object}

\item{result}{type of the result to be returned}

\item{x}{A \code{glmlist} or \code{loglmlist} object}

\item{type}{Type of output: \code{"brackets"} for loglinear bracket notation
(e.g., \code{"[AB] [C]"}), or \code{"formula"} for R formula notation.
For \code{glmlist} objects, only \code{"formula"} is meaningful.}

\item{abbrev}{Logical or integer. If \code{TRUE} or a positive integer,
abbreviate factor names to that many characters (default 1 when \code{TRUE}).
Only applies to bracket notation.}
}
\value{
An object of class \code{glmlist} \code{loglmlist}, just like a \code{list}, except that each model is given a \code{name} attribute.

A named character vector with the model formulas or bracket notations.
}
\description{
\code{glmlist} creates a \code{glmlist} object containing a list of fitted
\code{glm} objects with their names. \code{loglmlist} does the same for
\code{loglm} objects.

\code{get_models()} extracts the model formulas or bracket notation from each model in a
\code{glmlist} or \code{loglmlist} object. This is useful for labeling
models in summaries and plots.
}
\details{
The intention is to provide object classes to facilitate model comparison,
extraction, summary and plotting of model components, etc., perhaps using
\code{\link[base]{lapply}} or similar.

There exists a \code{\link[stats]{anova.glm}} method for \code{glmlist}
objects.  Here, a \code{coef} method is also defined, collecting the
coefficients from all models in a single object of type determined by
\code{result}.

The arguments to \code{glmlist} or \code{loglmlist} are of the form
\code{value} or \code{name=value}.

Any objects which do not inherit the appropriate class \code{glm} or
\code{loglm} are excluded, with a warning.

In the \code{coef} method, coefficients from the different models are
matched by name in the list of unique names across all models.

\strong{Model notation}

For \code{loglmlist} objects created by \code{\link{seq_loglm}}, the bracket
notation distinguishes between models fit to marginal sub-tables and
models fit to the full table. Parentheses are used for marginal
sub-tables, e.g., \code{"(Class) (Sex)"}, while square brackets are used
for the full table, e.g., \code{"[Class,Sex,Age] [Survived]"}.

The \code{\link{get_models}} function extracts these model strings,
and the \code{abbrev} argument can be used to abbreviate factor names
for more compact display, e.g., \code{"[C,S,A] [S]"}.

For \code{loglmlist} objects created by \code{\link{seq_loglm}}, the bracket
notation is stored in the \code{model.string} component. For other \code{loglm}
objects, it is constructed from the \code{margin} component using
\code{\link{loglin2string}}.

For \code{glmlist} objects, the formula is extracted using \code{formula()}.
}
\examples{

data(Mental)
indep <- glm(Freq ~ mental+ses,
                family = poisson, data = Mental)
Cscore <- as.numeric(Mental$ses)
Rscore <- as.numeric(Mental$mental)

coleff <- glm(Freq ~ mental + ses + Rscore:ses,
                family = poisson, data = Mental)
roweff <- glm(Freq ~ mental + ses + mental:Cscore,
                family = poisson, data = Mental)
linlin <- glm(Freq ~ mental + ses + Rscore:Cscore,
                family = poisson, data = Mental)

# use object names
mods <- glmlist(indep, coleff, roweff, linlin)
names(mods)

# assign new names
mods <- glmlist(Indep=indep, Col=coleff, Row=roweff, LinxLin=linlin)
names(mods)

LRstats(mods)

coef(mods, result='data.frame')

#extract model components
unlist(lapply(mods, deviance))

res <- lapply(mods, residuals)
boxplot(as.data.frame(res), main="Residuals from various models")

data(Titanic)
# Sequential models of joint independence
tit.joint <- seq_loglm(Titanic, type = "joint")
get_models(tit.joint)
get_models(tit.joint, type = "formula")

# With abbreviated factor names
get_models(tit.joint, abbrev = TRUE)
get_models(tit.joint, abbrev = 2)

}
\seealso{
The function \code{\link[Hmisc]{llist}} in package \code{Hmisc} is
similar, but perplexingly more general.

The function \code{\link[stats]{anova.glm}} also handles \verb{glmlist objects}

\code{\link{LRstats}} gives LR statistics and tests for a \code{glmlist}
object.

\code{\link{glmlist}}, \code{\link{loglmlist}}, \code{\link{loglin2string}},
\code{\link{LRstats}}

Other glmlist functions: 
\code{\link{Kway}()},
\code{\link{LRstats}()},
\code{\link{mosaic.glmlist}()}

Other loglinear models: 
\code{\link{get_model}()},
\code{\link{joint}()},
\code{\link{seq_loglm}()}

Other glmlist functions: 
\code{\link{Kway}()},
\code{\link{LRstats}()},
\code{\link{mosaic.glmlist}()}
}
\author{
Michael Friendly; \code{coef} method by John Fox
}
\concept{glmlist functions}
\concept{loglinear models}
\keyword{models}
\keyword{utilities}
