% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwise_genetic_diff.R
\name{pairwise_genetic_diff}
\alias{pairwise_genetic_diff}
\title{Pairwise genetic differentiation across populations}
\usage{
pairwise_genetic_diff(vcf, pops, method = "nei")
}
\arguments{
\item{vcf}{a vcfR object}

\item{pops}{factor indicating populations}

\item{method}{the method to measure differentiation}
}
\value{
a data frame containing the pairwise population differentiation indices of interest across all pairs of populations in the population factor.
}
\description{
\code{pairwise_genetic_diff} Calculate measures of genetic differentiation across all population pairs.
}
\examples{
data(vcfR_example)
pops <- as.factor(rep(c('a','b'), each = 9))
myDiff <- pairwise_genetic_diff(vcf, pops, method = "nei")
colMeans(myDiff[,c(4:ncol(myDiff))], na.rm = TRUE)
pops <- as.factor(rep(c('a','b','c'), each = 6))
myDiff <- pairwise_genetic_diff(vcf, pops, method = "nei")
colMeans(myDiff[,c(4:ncol(myDiff))], na.rm = TRUE)

}
\seealso{
\code{\link{genetic_diff}}
}
\author{
Javier F. Tabima
}
