% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/configuration.R
\name{vcr_configure}
\alias{vcr_configure}
\alias{local_vcr_configure}
\alias{vcr_configure_reset}
\alias{vcr_configuration}
\alias{vcr_config_defaults}
\title{Global Configuration Options}
\usage{
vcr_configure(
  dir,
  record,
  match_requests_on,
  serialize_with,
  json_pretty,
  ignore_hosts,
  ignore_localhost,
  preserve_exact_body_bytes,
  turned_off,
  re_record_interval,
  log,
  log_opts,
  filter_sensitive_data,
  filter_sensitive_data_regex,
  filter_request_headers,
  filter_response_headers,
  filter_query_parameters,
  write_disk_path,
  warn_on_empty_cassette
)

local_vcr_configure(..., .frame = parent.frame())

vcr_configure_reset()

vcr_configuration()

vcr_config_defaults()
}
\arguments{
\item{dir}{Directory where cassettes are stored.}

\item{record}{Record mode that dictates how HTTP requests/responses are
recorded. Possible values are:
\itemize{
\item \strong{once}, the default: Replays recorded interactions, records new ones
if no cassette exists, and errors on new requests if cassette exists.
\item \strong{none}: Replays recorded interactions, and errors on any new requests.
Guarantees that no HTTP requests occur.
\item \strong{new_episodes}: Replays recorded interactions and always records new
ones, even if similar interactions exist.
\item \strong{all}: Never replays recorded interactions, always recording new.
Useful for re-recording outdated responses or logging all HTTP requests.
}}

\item{match_requests_on}{Character vector of request matchers used to
determine which recorded HTTP interaction to replay. The default matches
on the \code{"method"}, \code{"uri"}, and either \code{"body"} (if present)
or \code{"body_json"} (if the content-type is \code{application/json}).

The full set of possible values are:
\itemize{
\item \code{method}: the HTTP method.
\item \code{uri}: the complete request URI, excluding the port.
\item \code{uri_with_port}: the complete request URI, including the port.
\item \code{host}: the \strong{host} component of the URI.
\item \code{path}: the \strong{path} component of the URI.
\item \code{query}: the \strong{query} component of the URI.
\item \code{body}: the request body.
\item \code{body_json}: the request body, parsed as JSON.
\item \code{header}: all request headers.
}

If more than one is specified, all components must match in order for the
request to match. If not supplied, defaults to \code{c("method", "uri")}.

Note that the request header and body will only be included in the
cassette if  \code{match_requests_on} includes "header" or "body" respectively.
This keeps the recorded request as lightweight as possible.}

\item{serialize_with}{(string) Which serializer to use:
\code{"yaml"} (the default), \code{"json"}, or \code{"qs2"}.}

\item{json_pretty}{(logical) want JSON to be newline separated to be easier
to read? Or remove newlines to save disk space? default: \code{FALSE}.}

\item{ignore_hosts}{(character) Vector of hosts to ignore. e.g.,
\code{"localhost"}, or \code{"google.com"}. These hosts are ignored and real HTTP
requests are allowed to go through.}

\item{ignore_localhost}{(logical) Default: \code{FALSE}}

\item{preserve_exact_body_bytes}{(logical) Force a binary (base64)
representation of the request and response bodies? By default, vcr
will look at the \code{Content-Type} header to determine if this is necessary,
but if it doesn't work you can set \code{preserve_exact_body_bytes = TRUE} to
force it.}

\item{turned_off}{(logical) VCR is turned on by default. Default:
\code{FALSE}.}

\item{re_record_interval}{(integer) How frequently (in seconds) the
cassette should be re-recorded. Default: \code{NULL} (not re-recorded).}

\item{log, log_opts}{See \code{\link[=vcr_configure_log]{vcr_configure_log()}}.}

\item{filter_sensitive_data, filter_sensitive_data_regex}{Transform header and/or body in the request and response.
Named list of substitutions to apply to the headers and body of the
request and response. Format is \code{list(replacement = "original")} where
\code{replacement} is a string that is matched exactly for
\code{filter_sensitive_data} and a regular expression for
\code{filter_sensitive_data_regex}.}

\item{filter_request_headers, filter_response_headers}{Filter request or response headers. Should be a list:
unnamed components are removed, and named components are transformed.
For example, \code{list("api_key")} would remove the \code{api_key} header and
\code{list(api_key = "***")} would replace the \code{api_key} header with \verb{***}.

httr2's redacted headers are automatically removed.}

\item{filter_query_parameters}{Filter query parameters in the request. A list where unnamed components
are removed, and named components are transformed. For example,
\code{list("api_key")} would remove the \code{api_key} parameter and
\code{list(api_key = "***")} would replace the \code{api_key} parameter with \verb{***}.}

\item{write_disk_path}{(character) path to write files to
for any requests that write responses to disk.  By default this will be
\verb{\{cassette-name\}-files/} inside the cassette directory.}

\item{warn_on_empty_cassette}{(logical) Should a warning be thrown when an
empty cassette is detected? Empty cassettes are cleaned up (deleted) either
way. This option only determines whether a warning is thrown or not.
Default: \code{TRUE}}

\item{...}{Configuration settings used to override defaults.}

\item{.frame}{Attach exit handlers to this environment. Typically, this
should be either the current environment or a parent frame (accessed
through \code{\link[=parent.frame]{parent.frame()}}). See \code{vignette("withr", package = "withr")}
for more details.}
}
\description{
Configurable options that define vcr's default behavior.
}
\examples{
vcr_configure(dir = tempdir())
vcr_configure(dir = tempdir(), record = "all")
vcr_configuration()
vcr_config_defaults()
vcr_configure(dir = tempdir(), ignore_hosts = "google.com")
vcr_configure(dir = tempdir(), ignore_localhost = TRUE)

# filter sensitive data
vcr_configure(dir = tempdir(),
  filter_sensitive_data = list(foo = "<bar>")
)
vcr_configure(dir = tempdir(),
  filter_sensitive_data = list(foo = "<bar>", hello = "<world>")
)
}
