% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tax.names.R
\name{taxname.simpl}
\alias{taxname.simpl}
\alias{taxname.simplify}
\title{Simplify name parts for better string matching}
\usage{
taxname.simplify(
  x,
  genus = TRUE,
  epithet = TRUE,
  concept = TRUE,
  rank = TRUE,
  tax.status = TRUE,
  ...
)
}
\arguments{
\item{x}{(integer or character) Species number, lettercode or species name(s)}

\item{genus}{(logical) simplify genus name part}

\item{epithet}{(logical) simplify epithet(s)}

\item{concept}{(logical) remove name parts which describe taxon concept size like "s. str.","s. l."}

\item{rank}{(logical) remove rank specifications}

\item{tax.status}{(logical) remove taxon status like 'nom. illeg.' or 'auct.'}

\item{\dots}{additional attributes}
}
\description{
Simplify name parts for better string matching
}
\details{
taxname.abbr will be applied beforehand automatically. The function simplifies name parts which are empirically unstable, i.e. sylvatica might also written as silvatica, or majus vs. maius. Sex of latin genus or epithet name parts often change and are therefore deleted (us vs. a, ea vs. eos, etc.). Hybrid signs are removed. taxname.simpl works well for plant names, but be careful with very long name lists or if combined with animal taxa which are sometimes very short and can be confused after applying taxname.simpl
}
\author{
Florian Jansen florian.jansen@uni-rostock.de
}
