% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_dm.R
\name{check_dm}
\alias{check_dm}
\title{Check binary variables}
\usage{
check_dm(.data, cols)
}
\arguments{
\item{.data}{A data.frame to be checked}

\item{cols}{A character vector, name of columns to look at (usually will be \code{d_names}, \code{a_names})}
}
\value{
A transposed data.frame, with row.names equal to \code{cols}, and first column
is the number of lines in \code{.data} where each col is equal to \code{1}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}} Quick check
that your data management steps through \code{\link{add_adr}}
or \code{\link{add_drug}} found cases.
}
\details{
It is a simple wrapper around \code{dplyr::summarise()}.
Be careful not to supply factors with > 2 levels or continuous outcome
(the function does NOT have a checker for this, so that it is faster).
Also, the function WONT work with NAs. Use \code{\link[=desc_facvar]{desc_facvar()}}.
if you need more detailed description of your dataset.
}
\examples{
# first create some new variables

demo <- demo_

demo <-
  demo |>
    add_adr(
      a_code = ex_$a_llt,
      adr_data = adr_
    )

 # then check the number of reports with each feature

demo |>
  check_dm(names(ex_$a_llt))
}
\seealso{
\code{\link[=desc_facvar]{desc_facvar()}}, \code{\link[=add_adr]{add_adr()}}, \code{\link[=add_drug]{add_drug()}}
}
\keyword{data_management}
