% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pedmatrix.R
\name{expand_pedmat}
\alias{expand_pedmat}
\title{Expand a Compact Pedigree Matrix to Full Dimensions}
\usage{
expand_pedmat(x)
}
\arguments{
\item{x}{A pedmat object from \code{\link{pedmat}}.}
}
\value{
Matrix or vector with original pedigree dimensions:
\itemize{
  \item Matrices: Row and column names set to all individual IDs
  \item Vectors (e.g., method="f"): Names set to all individual IDs
}
The result is \strong{not} a pedmat object (S3 class stripped).
}
\description{
Restores a compact pedmat to its original dimensions by mapping each
individual to their family representative's values. For non-compact matrices,
returns the matrix unchanged.
}
\details{
For compact matrices, full-siblings within the same family will have
identical relationship values in the expanded matrix because they shared
the same representative during calculation.
}
\examples{
tped <- tidyped(small_ped)

# Compact matrix
A_compact <- pedmat(tped, method = "A", compact = TRUE)
dim(A_compact)  # Reduced dimensions

# Expand to full size
A_full <- expand_pedmat(A_compact)
dim(A_full)  # Original dimensions restored

# Non-compact matrices are returned unchanged
A <- pedmat(tped, method = "A", compact = FALSE)
A2 <- expand_pedmat(A)
identical(dim(A), dim(A2))  # TRUE

}
\seealso{
\code{\link{pedmat}}, \code{\link{query_relationship}}
}
