% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vismi_overimp.R
\name{vismi_overimp}
\alias{vismi_overimp}
\title{Visualise Multiple Imputation Through Overimputation}
\usage{
vismi_overimp(
  obj,
  x = NULL,
  y = NULL,
  z = NULL,
  m = NULL,
  imp_idx = NULL,
  integerAsFactor = FALSE,
  title = "auto",
  subtitle = "auto",
  num_plot = "cv",
  fac_plot = "cv",
  train_color_pal = NULL,
  test_color_pal = NULL,
  stack_y = FALSE,
  diag_color = NULL,
  seed = 2025,
  ...
)
}
\arguments{
\item{obj}{Overimputation object of class 'overimp' created by the \code{overimp()} function.}

\item{x}{A character string specifying the name of the variable to plot on the x
axis. Default is NULL.}

\item{y}{A character string specifying the name of the variable to plot on the y
axis. Default is NULL.}

\item{z}{A character string specifying the name of the variable to plot on the z
axis. Default is NULL.}

\item{m}{A single positive integer specifying the number of imputed datasets to plot. It should be smaller than the total number of imputed datasets in the object.}

\item{imp_idx}{A vector of integers specifying the indices of imputed datasets to plot.}

\item{integerAsFactor}{A logical indicating whether integer variables should be treated as factors. Default is FALSE (treated as numeric).}

\item{title}{A string specifying the title of the plot. Default is "auto" (automatic title based on \code{x,y,z} input). If NULL, no title is shown.}

\item{subtitle}{A string specifying the subtitle of the plot. Default is "auto" (automatic subtitle based on \code{x,y,z} input). If NULL, no subtitle is shown.}

\item{num_plot}{A character string specifying the type of plot for numeric variables.}

\item{fac_plot}{A character string specifying the type of plot for categorical variables.}

\item{train_color_pal}{A vector of colors for the training data. If NULL, default colors will be used.}

\item{test_color_pal}{A vector of colors for the test data. If NULL, default colors will be used.}

\item{stack_y}{A logical indicating whether to stack y values in certain plots. Default is FALSE.}

\item{diag_color}{A character string specifying the color of the diagonal line in scatter plots. Default is NULL.}

\item{seed}{An integer specifying the random seed for reproducibility. Default is 2025.}

\item{...}{Additional arguments to customize the plots, such as position, point_size, linewidth, alpha, xlim, ylim, boxpoints, width.}
}
\value{
An \code{overimp_plot} object displaying the overimputation plots for training and test data (if users set \code{test_ratio > 0} in the \code{overimp()} function.)
}
\description{
This function provides overimputation diagnostics for assessing imputations generated by 'mice', 'mixgb' or other imputers. It supports evaluation on both training and test data.
}
\examples{
obj <- overimp(data = nhanes3, m = 3, p = 0.2, test_ratio = 0.2, method = "mixgb")
vismi_overimp(obj = obj, x = "head_circumference_cm", num_plot = "cv")
}
