% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generator.R
\name{gen_tbl}
\alias{gen_tbl}
\title{Generate a random tibble}
\usage{
gen_tbl(
  rows,
  cols = NULL,
  col_types = NULL,
  locale = default_locale(),
  missing = 0
)
}
\arguments{
\item{rows}{Number of rows to generate}

\item{cols}{Number of columns to generate, if \code{NULL} this is derived from \code{col_types}.}

\item{col_types}{One of \code{NULL}, a \code{\link[=cols]{cols()}} specification, or
a string.

If \code{NULL}, all column types will be inferred from \code{guess_max} rows
of the input, interspersed throughout the file. This is convenient (and
fast), but not robust. If the guessed types are wrong, you'll need to
increase \code{guess_max} or supply the correct types yourself.

Column specifications created by \code{\link[=list]{list()}} or \code{\link[=cols]{cols()}} must contain
one column specification for each column. If you only want to read a
subset of the columns, use \code{\link[=cols_only]{cols_only()}}.

Alternatively, you can use a compact string representation where each
character represents one column:
\itemize{
\item c = character
\item i = integer
\item I = big integer
\item n = number
\item d = double
\item l = logical
\item f = factor
\item D = date
\item T = date time
\item t = time
\item ? = guess
\item _ or - = skip
}

By default, reading a file without a column specification will print a
message showing the guessed types. To suppress this message, set
\code{show_col_types = FALSE}.}

\item{locale}{The locale controls defaults that vary from place to place.
The default locale is US-centric (like R), but you can use
\code{\link[=locale]{locale()}} to create your own locale that controls things like
the default time zone, encoding, decimal mark, big mark, and day/month
names.}

\item{missing}{The percentage (from 0 to 1) of missing data to use}
}
\description{
This is useful for benchmarking, but also for bug reports when you cannot
share the real dataset.
}
\details{
There is also a family of functions to generate individual vectors of each
type.
}
\examples{
# random 10 x 5 table with random column types
rand_tbl <- gen_tbl(10, 5)
rand_tbl

# all double 25 x 4 table
dbl_tbl <- gen_tbl(25, 4, col_types = "dddd")
dbl_tbl

# Use the dots in long form column types to change the random function and options
types <- rep(times = 4, list(col_double(f = stats::runif, min = -10, max = 25)))
types
dbl_tbl2 <- gen_tbl(25, 4, col_types = types)
dbl_tbl2
}
\seealso{
\link{generators} to generate individual vectors.
}
