% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/machine_learning.R
\name{wbt_modified_k_means_clustering}
\alias{wbt_modified_k_means_clustering}
\title{Modified k means clustering}
\usage{
wbt_modified_k_means_clustering(
  inputs,
  output,
  out_html = NULL,
  start_clusters = 1000,
  merge_dist = NULL,
  max_iterations = 10,
  class_change = 2,
  wd = NULL,
  verbose_mode = NULL,
  compress_rasters = NULL,
  command_only = FALSE
)
}
\arguments{
\item{inputs}{Input raster file paths, concatenated with \code{","} or \code{";"}. See \code{wbt_file_path()} for details.}

\item{output}{Output raster file.}

\item{out_html}{Output HTML report file.}

\item{start_clusters}{Initial number of clusters.}

\item{merge_dist}{Cluster merger distance.}

\item{max_iterations}{Maximum number of iterations.}

\item{class_change}{Minimum percent of cells changed between iterations before completion.}

\item{wd}{Changes the working directory. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_wd()} for details.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_verbose()} for details.}

\item{compress_rasters}{Sets the flag used by 'WhiteboxTools' to determine whether to use compression for output rasters. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_compress_rasters()} for details.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool. Default: \code{FALSE}.}
}
\value{
Returns the tool text outputs.
}
\description{
Performs a modified k-means clustering operation on a multi-spectral dataset.
}
\keyword{MachineLearning}
