% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wikipages.R
\name{wt_wiki_page_parse}
\alias{wt_wiki_page_parse}
\title{Parse MediaWiki Page}
\usage{
wt_wiki_page_parse(
  page,
  types = c("langlinks", "iwlinks", "externallinks"),
  tidy = FALSE
)
}
\arguments{
\item{page}{(\link[crul:HttpResponse]{crul::HttpResponse}) Result of \code{\link[=wt_wiki_page]{wt_wiki_page()}}}

\item{types}{(character) List of properties to parse.}

\item{tidy}{(logical). tidy output to data.frames when possible.
Default: \code{FALSE}}
}
\value{
a list
}
\description{
Parses common properties from the result of a MediaWiki API page call.
}
\details{
Available properties currently not parsed:
title, displaytitle, pageid, revid, redirects, text, categories,
links, templates, images, sections, properties, ...
}
\examples{
\dontrun{
pg <- wt_wiki_page("https://en.wikipedia.org/wiki/Malus_domestica")
wt_wiki_page_parse(pg)
}
}
\seealso{
Other MediaWiki functions: 
\code{\link{wt_wiki_page}()},
\code{\link{wt_wiki_url_build}()},
\code{\link{wt_wiki_url_parse}()}
}
\concept{MediaWiki functions}
