% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createNda.R, R/createNdaSubmissionTemplate.R
\name{to.nda}
\alias{to.nda}
\title{Create NDA Submission Template}
\usage{
to.nda(df, path = ".", skip_prompt = TRUE)

to.nda(df, path = ".", skip_prompt = TRUE)
}
\arguments{
\item{df}{Data frame to be used as template or character string naming a data frame
in the global environment.}

\item{path}{Character string specifying the directory path where the "tmp" folder
and template file should be created. Defaults to the current working directory.}

\item{skip_prompt}{Logical. If TRUE (default), skips the confirmation prompt. If FALSE,
will prompt for confirmation unless the user has previously chosen to remember their preference.}
}
\value{
Invisible TRUE if successful. Creates a CSV file at the specified path
and prints a message with the file location.

Invisible TRUE if successful. Creates a CSV file at the specified path
and prints a message with the file location.
}
\description{
This function creates a CSV template file for National Data Archive (NDA) submissions.
It extracts the data from a specified data frame and formats it according to NDA requirements,
with the structure name split into base name and suffix in the first line.
The function will prompt for confirmation before creating the file,
with an option to remember the user's preference for future calls.

This function creates a CSV template file for National Data Archive (NDA) submissions.
It extracts the data from a specified data frame and formats it according to NDA requirements,
with the structure name split into base name and suffix in the first line.
The function will prompt for confirmation before creating the file,
with an option to remember the user's preference for future calls.
}
\details{
The function will:
\enumerate{
\item Create a 'tmp' directory if it doesn't exist
\item Parse the structure name into base and suffix components (e.g., "eefrt01" → "eefrt" and "01")
\item Write the structure name components as the first line
\item Write column headers as the second line
\item Write the data rows below
}

The function will:
\enumerate{
\item Create a 'tmp' directory if it doesn't exist
\item Parse the structure name into base and suffix components (e.g., "eefrt01" → "eefrt" and "01")
\item Write the structure name components as the first line
\item Write column headers as the second line
\item Write the data rows below
}
}
\examples{
\dontrun{
  # First create some sample data
  eefrt01 <- data.frame(
    src_subject_id = c("SUB001", "SUB002"),
    interview_age = c(240, 360),
    interview_date = c("01/01/2023", "02/15/2023"),
    response_time = c(450, 520)
  )

  # Create the NDA template using the data frame directly
  to.nda(eefrt01)

  # Or using the name as a string
  to.nda("eefrt01")

  # Skip the confirmation prompt
  to.nda(eefrt01, skip_prompt = TRUE)
}

\dontrun{
  # First create some sample data
  eefrt01 <- data.frame(
    src_subject_id = c("SUB001", "SUB002"),
    interview_age = c(240, 360),
    interview_date = c("01/01/2023", "02/15/2023"),
    response_time = c(450, 520)
  )

  # Create the NDA template using the data frame directly
  to.nda(eefrt01)

  # Or using the name as a string
  to.nda("eefrt01")

  # Skip the confirmation prompt
  to.nda(eefrt01, skip_prompt = TRUE)
}

}
