% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make.R
\name{wk_linestring}
\alias{wk_linestring}
\alias{wk_polygon}
\alias{wk_collection}
\alias{wk_linestring_filter}
\alias{wk_polygon_filter}
\alias{wk_collection_filter}
\title{Create lines, polygons, and collections}
\usage{
wk_linestring(handleable, feature_id = 1L, ..., geodesic = NULL)

wk_polygon(handleable, feature_id = 1L, ring_id = 1L, ..., geodesic = NULL)

wk_collection(
  handleable,
  geometry_type = wk_geometry_type("geometrycollection"),
  feature_id = 1L,
  ...
)

wk_linestring_filter(handler, feature_id = 1L)

wk_polygon_filter(handler, feature_id = 1L, ring_id = 1L)

wk_collection_filter(
  handler,
  geometry_type = wk_geometry_type("geometrycollection"),
  feature_id = 1L
)
}
\arguments{
\item{handleable}{A geometry vector (e.g., \code{\link[=wkb]{wkb()}}, \code{\link[=wkt]{wkt()}}, \code{\link[=xy]{xy()}},
\code{\link[=rct]{rct()}}, or \code{\link[sf:sfc]{sf::st_sfc()}}) for which \code{\link[=wk_handle]{wk_handle()}} is defined.}

\item{feature_id}{An identifier where changes in sequential
values indicate a new feature. This is recycled silently
as needed.}

\item{...}{Passed to the \code{\link[=wk_handle]{wk_handle()}} method.}

\item{geodesic}{Use \code{TRUE} or \code{FALSE} to explicitly force
the geodesic-ness of the output.}

\item{ring_id}{An identifier where changes in sequential
values indicate a new ring. Rings are automatically
closed. This is recycled silently as needed.}

\item{geometry_type}{The collection type to create.}

\item{handler}{A \link[=wk_handle]{wk_handler} object.}
}
\value{
An object of the same class as \code{handleable} with
whose coordinates have been assembled into the given
type.
}
\description{
Create lines, polygons, and collections
}
\examples{
wk_linestring(xy(c(1, 1), c(2, 3)))
wk_polygon(xy(c(0, 1, 0), c(0, 0, 1)))
wk_collection(xy(c(1, 1), c(2, 3)))

}
