% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endpoint.R
\name{add_endpoint}
\alias{add_endpoint}
\title{Add endpoint to WORCS project}
\usage{
add_endpoint(filename = NULL, worcs_directory = ".", verbose = TRUE, ...)
}
\arguments{
\item{filename}{Character, indicating a file to be tracked as endpoint,
or \code{"testthat"} to add a folder of integration tests as endpoints.
Default: NULL.}

\item{worcs_directory}{Character, indicating the WORCS project directory
to which to save data. The default value "." points to the current directory.
Default: '.'}

\item{verbose}{Logical. Whether or not to print status messages to the
console. Default: TRUE}

\item{...}{Additional arguments.}
}
\value{
No return value. This function is called for its side effects.
}
\description{
Add a specific endpoint to the WORCS project file (a filename,
or \code{"testthat"} integration tests), see Details.
}
\details{
Endpoints are either:
\enumerate{
\item Files that are expected to be exactly reproducible (e.g.,
\code{"manuscript.html"}, \code{"myfigure.png"}, \code{"results_table.csv"}, et cetera).
For individual files, reproducibility is checked by ensuring that the
endpoint's checksum is unchanged, see \link[digest]{digest}. Be mindful that
the checksum also changes if two files are practically, but not literally,
identical. This can occur when using random numbers anywhere in your analysis
(e.g., Monte Carlo estimation, or even jittering points in a plot), or when
numbers are rounded differently in the 15th decimal on different computers.
\item A folder of integration tests, created using the \code{testthat} package (see
\link[worcs]{add_testthat}). Note that \code{testthat} allows you, for example, to
test whether numbers are equal within rounding tolerance.
}
}
\examples{
# Create directory to run the example
old_wd <- getwd()
test_dir <- file.path(tempdir(), "add_endpoint")
dir.create(test_dir)
setwd(test_dir)
file.create(".worcs")
writeLines("test", "test.txt")
add_endpoint("test.txt")
# Cleaning example directory
setwd(old_wd)
unlink(test_dir, recursive = TRUE)
}
\seealso{
\code{\link[worcs]{snapshot_endpoints}}
\code{\link[worcs]{check_endpoints}}
}
