% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endpoint.R
\name{list_endpoints}
\alias{list_endpoints}
\title{List endpoints in WORCS project}
\usage{
list_endpoints(worcs_directory = ".", verbose = TRUE, ...)
}
\arguments{
\item{worcs_directory}{Character, indicating the WORCS project directory
to which to save data. The default value "." points to the current directory.
Default: '.'}

\item{verbose}{Logical. Whether or not to print status messages to the
console. Default: TRUE}

\item{...}{Additional arguments.}
}
\value{
None, prints to the console.
}
\description{
List the endpoints in a WORCS project.
}
\examples{
if(requireNamespace("withr", quietly = TRUE)){
  withr::with_tempdir({
    file.create(".worcs")
    write.csv(iris, "iris.csv")
    add_endpoint("iris.csv")
    list_endpoints()
  })
}
}
\seealso{
\code{\link[worcs]{add_endpoint}}
\code{\link[worcs]{snapshot_endpoints}}
}
