% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explicit_guide.R
\name{infer_guide}
\alias{infer_guide}
\title{Infer Type of Guide}
\usage{
infer_guide(x, data = NULL, default = "guide", token = "data", ...)
}
\arguments{
\item{x}{character or list}

\item{data}{atomic}

\item{default}{value for unrecognized guides}

\item{token}{character: discriptive term for 'data' used in warning}

\item{...}{ignored}
}
\value{
length-one character
}
\description{
Infers type of guide.
Default mapping function for \code{\link{explicit_guide.yamlet}}
where it replaces the key 'guide' with the return value.
}
\details{
* If x is a list, the result is 'codelist'.

* If x otherwise has length greater than 1, result is the default value.

* If x \code{\link{is_parseable}}, result is 'units'.
  Use \code{\link[units]{install_unit}} to register a non-default unit.

* If x contains two or more percent signs, result is 'format'
  (i.e. a 'format' string for a date or time class).

* If x is (\code{\link[encode]{encoded}}), result is 'encoding'.

* A length-one value of x not otherwise recognized is
  assumed to be an attempt to provide a length-one 'codelist'.

If data is supplied (not NULL), a warning is issued for
a codelist with elements not present.
}
\examples{
infer_guide('a') # recognized unit
infer_guide('z') # unrecognized as unit, evaluates to guide
\dontrun{
# evaluates to codelist but data suggests otherwise (warning)
infer_guide(as.list(letters), data = LETTERS)
}
infer_guide(c(1,2,3))                   # guide
infer_guide(list('a','b','c'))          # codelist
infer_guide(list(a = 1, b = 2, c = 3))  # codelist
infer_guide(list(a = 1))                # codelist
infer_guide('kg/m^2')                   # units
infer_guide('\%')                        # units
infer_guide('\%Y-\%m-\%d')                 # format
infer_guide('//a/1//b/2//c/3//')        # encoding

}
\seealso{
Other explicit_guide: 
\code{\link{explicit_guide}()},
\code{\link{explicit_guide.data.frame}()},
\code{\link{explicit_guide.dvec}()},
\code{\link{explicit_guide.factor}()},
\code{\link{explicit_guide.yamlet}()},
\code{\link{implicit_guide}()},
\code{\link{implicit_guide.data.frame}()},
\code{\link{implicit_guide.dvec}()},
\code{\link{implicit_guide.factor}()}
}
\concept{explicit_guide}
\keyword{internal}
